﻿Imports System.Diagnostics
Imports System.Globalization

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private stopwatch As New Diagnostics.Stopwatch()
    Private suspensionAdjustment As New TimeSpan()
    Private decimalSeparator As String = NumberFormatInfo.CurrentInfo.NumberDecimalSeparator


    Public Sub New()
        InitializeComponent()
        DisplayTime()
    End Sub


    Private Sub OnToggleButtonChecked(ByVal sender As Object, ByVal e As RoutedEventArgs)
        If CBool(startStopToggle.IsChecked) Then
            stopwatch.Start()
            startStopToggle.Content = "Stop"
            AddHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
        Else
            stopwatch.Stop()
            startStopToggle.Content = "Start"
            RemoveHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
        End If
    End Sub


    Private Sub OnCompositionTargetRendering(ByVal sender As Object, ByVal args As EventArgs)
        DisplayTime()
    End Sub


    Private Sub OnAppbarResetClick(ByVal sender As Object, ByVal args As EventArgs)
        stopwatch.Reset()
        startStopToggle.IsChecked = False
        suspensionAdjustment = New TimeSpan()
        DisplayTime()
    End Sub


    Private Sub OnAppbarFormatClick(ByVal sender As Object, ByVal args As EventArgs)
        disableRect.Visibility = System.Windows.Visibility.Visible
        formatDialog.Visibility = System.Windows.Visibility.Visible

        ' Initialize radio buttons
        Dim currentFormat = (TryCast(Application.Current, App)).ElapsedTimeFormat

        For Each child In radioButtonPanel.Children
            Dim radio = TryCast(child, RadioButton)
            Dim radioFormat =
                CType(System.Enum.Parse(GetType(ElapsedTimeFormat), TryCast(radio.Tag, String), True), ElapsedTimeFormat)
            radio.IsChecked = (currentFormat = radioFormat)
        Next child
    End Sub


    Private Sub OnOkButtonClick(ByVal sender As Object, ByVal args As RoutedEventArgs)
        For Each child In radioButtonPanel.Children
            Dim radio = TryCast(child, RadioButton)
            If CBool(radio.IsChecked) Then
                TryCast(Application.Current, App).ElapsedTimeFormat =
                    CType(System.Enum.Parse(GetType(ElapsedTimeFormat), TryCast(radio.Tag, String), True), ElapsedTimeFormat)
            End If
        Next child

        OnCancelButtonClick(sender, args)
    End Sub


    Private Sub OnCancelButtonClick(ByVal sender As Object, ByVal args As RoutedEventArgs)
        disableRect.Visibility = System.Windows.Visibility.Collapsed
        formatDialog.Visibility = System.Windows.Visibility.Collapsed
        DisplayTime()
    End Sub


    Private Sub DisplayTime()
        Dim elapsedTime = stopwatch.Elapsed + suspensionAdjustment
        Dim str As String = Nothing

        Select Case (TryCast(Application.Current, App)).ElapsedTimeFormat
            Case ElapsedTimeFormat.HourMinuteSecond
                str = String.Format("{0:D2} {1:D2} {2:D2}{3}{4:D2}",
                                    elapsedTime.Hours, elapsedTime.Minutes,
                                    elapsedTime.Seconds, decimalSeparator,
                                    elapsedTime.Milliseconds \ 10)

            Case ElapsedTimeFormat.Seconds
                str = String.Format("{0:F2} sec", elapsedTime.TotalSeconds)

            Case ElapsedTimeFormat.Milliseconds
                str = String.Format("{0:F0} msec", elapsedTime.TotalMilliseconds)
        End Select

        elapsedText.Text = str
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        Dim service = PhoneApplicationService.Current
        service.State("stopWatchRunning") = CBool(startStopToggle.IsChecked)
        service.State("suspensionAdjustment") = suspensionAdjustment + stopwatch.Elapsed
        service.State("tombstoneBeginTime") = Date.Now

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        Dim service = PhoneApplicationService.Current

        If service.State.ContainsKey("stopWatchRunning") Then
            suspensionAdjustment = CType(service.State("suspensionAdjustment"), TimeSpan)

            If CBool(service.State("stopWatchRunning")) Then
                suspensionAdjustment += CType(Date.Now - CDate(service.State("tombstoneBeginTime")), TimeSpan)
                startStopToggle.IsChecked = True
            Else
                DisplayTime()
            End If
        End If
        MyBase.OnNavigatedTo(args)
    End Sub
End Class